package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VestadisticaFormaPre;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VestadisticaFormaPreDaoImpl generated by UDA, 18-sep-2017 9:23:56.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VestadisticaFormaPreDaoImpl implements VestadisticaFormaPreDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VestadisticaFormaPre> rwMap = new RowMapper<VestadisticaFormaPre>() {
		public VestadisticaFormaPre mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			VestadisticaFormaPre vestadistica = new VestadisticaFormaPre();

			vestadistica.setProcedimiento(resultSet.getLong("PROCEDIMIENTO"));
			vestadistica.setTerritorio(resultSet.getString("TERRITORIO"));
			vestadistica.setAnio(resultSet.getString("ANIO"));
			vestadistica.setSemana(resultSet.getString("SEMANA"));
			vestadistica.setTotal(resultSet.getLong("TOTAL"));
			vestadistica.setTelematico(resultSet.getLong("TELEMATICO"));
			vestadistica.setPresencial(resultSet.getLong("PRESENCIAL"));

			vestadistica.setProcedimientoDesc(resultSet
					.getString("PROCEDIMIENTODESC"));
			vestadistica.setTerDesc(resultSet.getString("TERRITORIODESC"));

			return vestadistica;
		}
	};

	private RowMapper<VestadisticaFormaPre> rwMapSemana = new RowMapper<VestadisticaFormaPre>() {
		public VestadisticaFormaPre mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			VestadisticaFormaPre vestadistica = new VestadisticaFormaPre();

			vestadistica.setProcedimiento(resultSet.getLong("PROCEDIMIENTO"));
			vestadistica.setTerritorio(resultSet.getString("TERRITORIO"));
			vestadistica.setAnio(resultSet.getString("ANIO"));
			vestadistica.setMes(resultSet.getString("MES"));
			vestadistica.setSemana(resultSet.getString("SEMANA"));
			vestadistica.setTotal(resultSet.getLong("TOTAL"));
			vestadistica.setTelematico(resultSet.getLong("TELEMATICO"));
			vestadistica.setPresencial(resultSet.getLong("PRESENCIAL"));

			vestadistica.setProcedimientoDesc(resultSet
					.getString("PROCEDIMIENTODESC"));
			vestadistica.setTerDesc(resultSet.getString("TERRITORIODESC"));

			return vestadistica;
		}
	};

	private RowMapper<VestadisticaFormaPre> rwMapMes = new RowMapper<VestadisticaFormaPre>() {
		public VestadisticaFormaPre mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			VestadisticaFormaPre vestadistica = new VestadisticaFormaPre();

			vestadistica.setProcedimiento(resultSet.getLong("PROCEDIMIENTO"));
			vestadistica.setTerritorio(resultSet.getString("TERRITORIO"));
			vestadistica.setAnio(resultSet.getString("ANIO"));
			vestadistica.setMes(resultSet.getString("MES"));
			vestadistica.setTotal(resultSet.getLong("TOTAL"));
			vestadistica.setTelematico(resultSet.getLong("TELEMATICO"));
			vestadistica.setPresencial(resultSet.getLong("PRESENCIAL"));

			vestadistica.setProcedimientoDesc(resultSet
					.getString("PROCEDIMIENTODESC"));
			vestadistica.setTerDesc(resultSet.getString("TERRITORIODESC"));

			return vestadistica;
		}
	};

	private RowMapper<VestadisticaFormaPre> rwMapAnio = new RowMapper<VestadisticaFormaPre>() {
		public VestadisticaFormaPre mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			VestadisticaFormaPre vestadistica = new VestadisticaFormaPre();

			vestadistica.setProcedimiento(resultSet.getLong("PROCEDIMIENTO"));
			vestadistica.setTerritorio(resultSet.getString("TERRITORIO"));
			vestadistica.setAnio(resultSet.getString("ANIO"));
			vestadistica.setTotal(resultSet.getLong("TOTAL"));
			vestadistica.setTelematico(resultSet.getLong("TELEMATICO"));
			vestadistica.setPresencial(resultSet.getLong("PRESENCIAL"));

			vestadistica.setProcedimientoDesc(resultSet
					.getString("PROCEDIMIENTODESC"));
			vestadistica.setTerDesc(resultSet.getString("TERRITORIODESC"));

			return vestadistica;
		}
	};

	private RowMapper<VestadisticaFormaPre> rwMapPK = new RowMapper<VestadisticaFormaPre>() {
		public VestadisticaFormaPre mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VestadisticaFormaPre(resultSet.getLong("PROCEDIMIENTO"),
					resultSet.getString("TERRITORIO"),
					resultSet.getString("ANIO"), resultSet.getString("SEMANA"),
					resultSet.getString("MES"), resultSet.getLong("TOTAL"),
					resultSet.getLong("TELEMATICO"),
					resultSet.getLong("PRESENCIAL"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VestadisticaFormaPre table.
	 * 
	 * vestadisticaformapre VestadisticaFormaPre VestadisticaFormaPre
	 * 
	 * @param vestadisticaformapre
	 *            the vestadisticaformapre
	 * @return the vestadistica forma pre
	 */
	public VestadisticaFormaPre add(VestadisticaFormaPre vestadisticaformapre) {
		String query = "INSERT INTO VESTADISTICA_FORMA_PRE (PROCEDIMIENTO, TERRITORIO, ANIO, SEMANA, MES, TOTAL, TELEMATICO, PRESENCIAL) VALUES (?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query,
				vestadisticaformapre.getProcedimiento(),
				vestadisticaformapre.getTerritorio(),
				vestadisticaformapre.getAnio(),
				vestadisticaformapre.getSemana(),
				vestadisticaformapre.getMes(), vestadisticaformapre.getTotal(),
				vestadisticaformapre.getTelematico(),
				vestadisticaformapre.getPresencial());
		return vestadisticaformapre;
	}

	/**
	 * Updates a single row in the VestadisticaFormaPre table.
	 * 
	 * vestadisticaformapre VestadisticaFormaPre VestadisticaFormaPre
	 * 
	 * @param vestadisticaformapre
	 *            the vestadisticaformapre
	 * @return the vestadistica forma pre
	 */
	public VestadisticaFormaPre update(VestadisticaFormaPre vestadisticaformapre) {
		String query = "UPDATE VESTADISTICA_FORMA_PRE SET  WHERE PROCEDIMIENTO=? AND TERRITORIO=? AND ANIO=? AND SEMANA=? AND MES=? AND TOTAL=? AND TELEMATICO=? AND PRESENCIAL=?";
		this.jdbcTemplate.update(query,
				vestadisticaformapre.getProcedimiento(),
				vestadisticaformapre.getTerritorio(),
				vestadisticaformapre.getAnio(),
				vestadisticaformapre.getSemana(),
				vestadisticaformapre.getMes(), vestadisticaformapre.getTotal(),
				vestadisticaformapre.getTelematico(),
				vestadisticaformapre.getPresencial());
		return vestadisticaformapre;
	}

	/**
	 * Finds a single row in the VestadisticaFormaPre table.
	 * 
	 * vestadisticaformapre VestadisticaFormaPre VestadisticaFormaPre
	 * 
	 * @param vestadisticaformapre
	 *            the vestadisticaformapre
	 * @return the vestadistica forma pre
	 */
	@Transactional(readOnly = true)
	public VestadisticaFormaPre find(VestadisticaFormaPre vestadisticaformapre) {
		String query = "SELECT t1.PROCEDIMIENTO PROCEDIMIENTO, t1.TERRITORIO TERRITORIO, t1.ANIO ANIO, t1.SEMANA SEMANA, t1.MES MES, t1.TOTAL TOTAL, t1.TELEMATICO TELEMATICO, t1.PRESENCIAL PRESENCIAL FROM VESTADISTICA_FORMA_PRE t1  WHERE t1.PROCEDIMIENTO = ?   AND t1.TERRITORIO = ?   AND t1.ANIO = ?   AND t1.SEMANA = ?   AND t1.MES = ?   AND t1.TOTAL = ?   AND t1.TELEMATICO = ?   AND t1.PRESENCIAL = ?  ";

		List<VestadisticaFormaPre> vestadisticaformapreList = this.jdbcTemplate
				.query(query, this.rwMap,
						vestadisticaformapre.getProcedimiento(),
						vestadisticaformapre.getTerritorio(),
						vestadisticaformapre.getAnio(),
						vestadisticaformapre.getSemana(),
						vestadisticaformapre.getMes(),
						vestadisticaformapre.getTotal(),
						vestadisticaformapre.getTelematico(),
						vestadisticaformapre.getPresencial());
		return (VestadisticaFormaPre) DataAccessUtils
				.uniqueResult(vestadisticaformapreList);
	}

	/**
	 * Removes a single row in the VestadisticaFormaPre table.
	 * 
	 * vestadisticaformapre VestadisticaFormaPre
	 * 
	 * @param vestadisticaformapre
	 *            the vestadisticaformapre
	 */
	public void remove(VestadisticaFormaPre vestadisticaformapre) {
		String query = "DELETE FROM VESTADISTICA_FORMA_PRE WHERE PROCEDIMIENTO=? AND TERRITORIO=? AND ANIO=? AND SEMANA=? AND MES=? AND TOTAL=? AND TELEMATICO=? AND PRESENCIAL=?";
		this.jdbcTemplate.update(query,
				vestadisticaformapre.getProcedimiento(),
				vestadisticaformapre.getTerritorio(),
				vestadisticaformapre.getAnio(),
				vestadisticaformapre.getSemana(),
				vestadisticaformapre.getMes(), vestadisticaformapre.getTotal(),
				vestadisticaformapre.getTelematico(),
				vestadisticaformapre.getPresencial());
	}

	/**
	 * Finds a list of rows in the VestadisticaFormaPre table.
	 * 
	 * vestadisticaformapre VestadisticaFormaPre jqGridRequestDto
	 * JQGridRequestDto List<VestadisticaFormaPre>
	 * 
	 * @param vestadisticaformapre
	 *            the vestadisticaformapre
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VestadisticaFormaPre> findAll(
			VestadisticaFormaPre vestadisticaformapre,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.PROCEDIMIENTO PROCEDIMIENTO,t1.TERRITORIO TERRITORIO,t1.ANIO ANIO,t1.SEMANA SEMANA,t1.MES MES,t1.TOTAL TOTAL,t1.TELEMATICO TELEMATICO,t1.PRESENCIAL PRESENCIAL ");
		query.append("FROM VESTADISTICA_FORMA_PRE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vestadisticaformapre);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND MES IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VestadisticaFormaPre>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VestadisticaFormaPre table using like.
	 * 
	 * vestadisticaformapre VestadisticaFormaPre jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<VestadisticaFormaPre>
	 * 
	 * @param vestadisticaformapre
	 *            the vestadisticaformapre
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VestadisticaFormaPre> findAllLike(
			VestadisticaFormaPre vestadisticaformapre,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder();
		if (vestadisticaformapre.getAgrupacion().equals("semanas")) {
			query.append("SELECT  t1.PROCEDIMIENTO PROCEDIMIENTO,t1.TERRITORIO TERRITORIO,t1.ANIO ANIO,t1.SEMANA SEMANA,t1.MES MES,SUM(t1.TOTAL) TOTAL,SUM(t1.TELEMATICO) TELEMATICO,SUM(t1.PRESENCIAL) PRESENCIAL, d1.DS_O TERRITORIODESC, d2.DESCRIPCION_088 PROCEDIMIENTODESC ");

		} else if (vestadisticaformapre.getAgrupacion().equals("meses")) {
			query.append("SELECT  t1.PROCEDIMIENTO PROCEDIMIENTO,t1.TERRITORIO TERRITORIO,t1.ANIO ANIO,t1.MES MES,SUM(t1.TOTAL) TOTAL,SUM(t1.TELEMATICO) TELEMATICO,SUM(t1.PRESENCIAL) PRESENCIAL, d1.DS_O TERRITORIODESC, d2.DESCRIPCION_088 PROCEDIMIENTODESC ");

		} else if (vestadisticaformapre.getAgrupacion().equals("anios")) {
			query.append("SELECT  t1.PROCEDIMIENTO PROCEDIMIENTO,t1.TERRITORIO TERRITORIO,t1.ANIO ANIO, SUM(t1.TOTAL) TOTAL,SUM(t1.TELEMATICO) TELEMATICO,SUM(t1.PRESENCIAL) PRESENCIAL, d1.DS_O TERRITORIODESC, d2.DESCRIPCION_088 PROCEDIMIENTODESC ");

		}
		query.append("FROM VESTADISTICA_FORMA_PRE t1 ");

		// JOINS
		query.append("  LEFT JOIN PROVINCIA_NORA d1 ON d1.ID = t1.TERRITORIO LEFT JOIN AB0488S00 d2 ON d2.CODTABLA_088 = 'TIPO_PROC_LIST' AND d2.CODIGO_088   = t1.PROCEDIMIENTO ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vestadisticaformapre,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND MES IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		if (vestadisticaformapre.getAgrupacion().equals("semanas")) {
			query.append(" GROUP BY PROCEDIMIENTO,TERRITORIO,ANIO,SEMANA,MES, d1.DS_O,d2.DESCRIPCION_088 ORDER BY PROCEDIMIENTO, TERRITORIO, ANIO, MES, SEMANA ");

		} else if (vestadisticaformapre.getAgrupacion().equals("meses")) {
			query.append(" GROUP BY PROCEDIMIENTO,TERRITORIO,ANIO,MES, d1.DS_O,d2.DESCRIPCION_088 ORDER BY PROCEDIMIENTO, TERRITORIO, ANIO, MES ");

		} else if (vestadisticaformapre.getAgrupacion().equals("anios")) {
			query.append(" GROUP BY PROCEDIMIENTO,TERRITORIO,ANIO, d1.DS_O,d2.DESCRIPCION_088 ORDER BY PROCEDIMIENTO, TERRITORIO, ANIO ");

		}
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		List<VestadisticaFormaPre> lista = null;
		if (vestadisticaformapre.getAgrupacion().equals("semanas")) {
			lista = (List<VestadisticaFormaPre>) this.jdbcTemplate.query(
					query.toString(), this.rwMapSemana, params.toArray());
		} else if (vestadisticaformapre.getAgrupacion().equals("meses")) {
			lista = (List<VestadisticaFormaPre>) this.jdbcTemplate.query(
					query.toString(), this.rwMapMes, params.toArray());
		} else if (vestadisticaformapre.getAgrupacion().equals("anios")) {
			lista = (List<VestadisticaFormaPre>) this.jdbcTemplate.query(
					query.toString(), this.rwMapAnio, params.toArray());
		}
		return lista;
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VestadisticaFormaPre table.
	 * 
	 * vestadisticaformapre VestadisticaFormaPre Long
	 * 
	 * @param vestadisticaformapre
	 *            the vestadisticaformapre
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VestadisticaFormaPre vestadisticaformapre) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VESTADISTICA_FORMA_PRE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vestadisticaformapre);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND MES IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VestadisticaFormaPre table using like.
	 * 
	 * vestadisticaformapre VestadisticaFormaPre startsWith Boolean Long
	 * 
	 * @param vestadisticaformapre
	 *            the vestadisticaformapre
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(VestadisticaFormaPre vestadisticaformapre,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM(SELECT '1' FROM VESTADISTICA_FORMA_PRE t1 ");
		// JOINS
		query.append("  LEFT JOIN PROVINCIA_NORA d1 ON d1.ID = t1.TERRITORIO LEFT JOIN AB0488S00 d2 ON d2.CODTABLA_088 = 'TIPO_PROC_LIST' AND d2.CODIGO_088   = t1.PROCEDIMIENTO ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vestadisticaformapre,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND MES IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		if (vestadisticaformapre.getAgrupacion().equals("semanas")) {
			query.append(" GROUP BY PROCEDIMIENTO,TERRITORIO,ANIO,SEMANA,MES, d1.DS_O,d2.DESCRIPCION_088) ");

		} else if (vestadisticaformapre.getAgrupacion().equals("meses")) {
			query.append(" GROUP BY PROCEDIMIENTO,TERRITORIO,ANIO,MES, d1.DS_O,d2.DESCRIPCION_088) ");

		} else if (vestadisticaformapre.getAgrupacion().equals("anios")) {
			query.append(" GROUP BY PROCEDIMIENTO,TERRITORIO,ANIO, d1.DS_O,d2.DESCRIPCION_088) ");

		}
		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VestadisticaFormaPre selected for rup_table.
	 * 
	 * vestadisticaformapre VestadisticaFormaPre jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<VestadisticaFormaPre>>
	 * 
	 * @param vestadisticaformapre
	 *            the vestadisticaformapre
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VestadisticaFormaPre>> reorderSelection(
			VestadisticaFormaPre vestadisticaformapre,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.PROCEDIMIENTO PROCEDIMIENTO,t1.TERRITORIO TERRITORIO,t1.ANIO ANIO,t1.SEMANA SEMANA,t1.MES MES,t1.TOTAL TOTAL,t1.TELEMATICO TELEMATICO,t1.PRESENCIAL PRESENCIAL ");
		// FROM
		query.append("FROM VESTADISTICA_FORMA_PRE t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vestadisticaformapre,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND MES IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getReorderQuery(query, jqGridRequestDto,
						VestadisticaFormaPre.class, filterParamList,
						"PROCEDIMIENTO,TERRITORIO,ANIO,SEMANA,MES,TOTAL,TELEMATICO,PRESENCIAL");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VestadisticaFormaPre>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams VestadisticaFormaPre searchParams VestadisticaFormaPre
	 * jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<VestadisticaFormaPre>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VestadisticaFormaPre>> search(
			VestadisticaFormaPre filterParams,
			VestadisticaFormaPre searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.PROCEDIMIENTO PROCEDIMIENTO,t1.TERRITORIO TERRITORIO,t1.ANIO ANIO,t1.SEMANA SEMANA,t1.MES MES,t1.TOTAL TOTAL,t1.TELEMATICO TELEMATICO,t1.PRESENCIAL PRESENCIAL ");
		// FROM
		query.append("FROM VESTADISTICA_FORMA_PRE t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(query, jqGridRequestDto,
						VestadisticaFormaPre.class, filterParamList, searchSQL,
						searchParamList, from_alias,
						"PROCEDIMIENTO,TERRITORIO,ANIO,SEMANA,MES,TOTAL,TELEMATICO,PRESENCIAL");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VestadisticaFormaPre>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filtervestadisticaformapre VestadisticaFormaPre jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean
	 * 
	 * @param filtervestadisticaformapre
	 *            the filtervestadisticaformapre
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override
	public void removeMultiple(VestadisticaFormaPre filtervestadisticaformapre,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.PROCEDIMIENTO PROCEDIMIENTO,t1.TERRITORIO TERRITORIO,t1.ANIO ANIO,t1.SEMANA SEMANA,t1.MES MES,t1.TOTAL TOTAL,t1.TELEMATICO TELEMATICO,t1.PRESENCIAL PRESENCIAL ");
		// FROM
		query.append("FROM VESTADISTICA_FORMA_PRE t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(
				filtervestadisticaformapre, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						VestadisticaFormaPre.class, query, params,
						"PROCEDIMIENTO,TERRITORIO,ANIO,SEMANA,MES,TOTAL,TELEMATICO,PRESENCIAL");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VestadisticaFormaPre entity.
	 * 
	 * vestadisticaformapre VestadisticaFormaPre Bean with the criteria values
	 * to filter by. Map created with two keys key query stores the sql query
	 * syntax key params stores the parameter values to be used in the condition
	 * sentence.
	 * 
	 * @param vestadisticaformapre
	 *            the vestadisticaformapre
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(VestadisticaFormaPre vestadisticaformapre) {

		StringBuilder where = new StringBuilder(
				VestadisticaFormaPreDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vestadisticaformapre != null
				&& vestadisticaformapre.getProcedimiento() != null) {
			where.append(" AND t1.PROCEDIMIENTO = ?");
			params.add(vestadisticaformapre.getProcedimiento());
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getTerritorio() != null) {
			where.append(" AND t1.TERRITORIO = ?");
			params.add(vestadisticaformapre.getTerritorio());
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getAnio() != null) {
			where.append(" AND t1.ANIO = ?");
			params.add(vestadisticaformapre.getAnio());
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getSemana() != null) {
			where.append(" AND t1.SEMANA = ?");
			params.add(vestadisticaformapre.getSemana());
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getMes() != null) {
			where.append(" AND t1.MES = ?");
			params.add(vestadisticaformapre.getMes());
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getTotal() != null) {
			where.append(" AND t1.TOTAL = ?");
			params.add(vestadisticaformapre.getTotal());
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getTelematico() != null) {
			where.append(" AND t1.TELEMATICO = ?");
			params.add(vestadisticaformapre.getTelematico());
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getPresencial() != null) {
			where.append(" AND t1.PRESENCIAL = ?");
			params.add(vestadisticaformapre.getPresencial());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VestadisticaFormaPre entity.
	 * 
	 * vestadisticaformapre VestadisticaFormaPre Bean with the criteria values
	 * to filter by. startsWith Boolean Map created with two keys key query
	 * stores the sql query syntax key params stores the parameter values to be
	 * used in the condition sentence.
	 * 
	 * @param vestadisticaformapre
	 *            the vestadisticaformapre
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(
			VestadisticaFormaPre vestadisticaformapre, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VestadisticaFormaPreDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vestadisticaformapre != null
				&& vestadisticaformapre.getProcedimiento() != null) {
			where.append(" AND t1.PROCEDIMIENTO = ?");
			params.add(vestadisticaformapre.getProcedimiento());
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getTerritorio() != null) {
			where.append(" AND UPPER(t1.TERRITORIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vestadisticaformapre.getTerritorio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vestadisticaformapre.getTerritorio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TERRITORIO IS NOT NULL");
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getAnio() != null) {
			where.append(" AND UPPER(t1.ANIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vestadisticaformapre.getAnio().toUpperCase() + "%");
			} else {
				params.add("%" + vestadisticaformapre.getAnio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ANIO IS NOT NULL");
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getSemana() != null) {
			where.append(" AND UPPER(t1.SEMANA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vestadisticaformapre.getSemana().toUpperCase() + "%");
			} else {
				params.add("%" + vestadisticaformapre.getSemana().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.SEMANA IS NOT NULL");
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getMes() != null) {
			where.append(" AND UPPER(t1.MES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vestadisticaformapre.getMes().toUpperCase() + "%");
			} else {
				params.add("%" + vestadisticaformapre.getMes().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MES IS NOT NULL");
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getTotal() != null) {
			where.append(" AND t1.TOTAL = ?");
			params.add(vestadisticaformapre.getTotal());
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getTelematico() != null) {
			where.append(" AND t1.TELEMATICO = ?");
			params.add(vestadisticaformapre.getTelematico());
		}
		if (vestadisticaformapre != null
				&& vestadisticaformapre.getPresencial() != null) {
			where.append(" AND t1.PRESENCIAL = ?");
			params.add(vestadisticaformapre.getPresencial());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
